class ActivityController < ApplicationController
  def index
  end
  
  def list_processes
    @processes = Activity.find_all("datname = '#{ActiveRecord::Base.configurations[RAILS_ENV]['database']}'")
    render :layout => false
  end
  
  def explain
    @statement = params['statement']
    @plan = "\n"
    if statement_check(@statement)
      Activity.find_by_sql("explain #{@statement}").collect do |plan|
        @plan += plan.attributes['QUERY PLAN'] + "\n" unless plan.attributes['QUERY PLAN'] == ''
      end 
    end
    render :layout => false
  end
  
  def explain_analyze
    @statement = params['statement']
    @plan = "\n"
    Activity.find_by_sql("explain analyze #{@statement}").collect { |plan| @plan += plan.attributes['QUERY PLAN'] + "\n" } if statement_check(@statement)
    render :layout => false
  end

  def statement_check(statement = @statement)
    return true unless statement =~ /IDLE/ or statement =~ /BEGIN/ or statement =~ /COMMIT/
    return false
  end
end
