class ActivityController < ApplicationController
  def index
  end
  
  def list_processes
    @processes = Activity.find_all
    render :layout => false
  end
  
  def explain
    @statement = params['id']
    @plan = String.new
    Activity.find_by_sql("explain #{@statement}").collect { |plan| @plan += plan.attributes['QUERY PLAN'] + "\n" } if statement_check(@statement)
    render :layout => false
  end
  
  def explain_analyze
    @statement = params['id']
    @plan = String.new
    Activity.find_by_sql("explain analyze #{@statement}").collect { |plan| @plan += plan.attributes['QUERY PLAN'] + "\n" } if statement_check(@statement)
    render :layout => false
  end

  def statement_check(statement = @statement)
    return true unless statement =~ /IDLE/ or statement =~ /BEGIN/ or statement =~ /COMMIT/
    return false
  end
end
