<?xml version="1.0" encoding="utf-8" ?>
<!-- Copyright (c) 2009-2010, NIPPON TELEGRAPH AND TELEPHONE CORPORATION -->

<xsl:stylesheet version="1.0" 
  xmlns="http://www.w3.org/1999/xhtml"
  xmlns:html="http://www.w3.org/1999/xhtml"
  xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
  xmlns:pg="http://pgstatsinfo.projects.postgresql.org/">

  <xsl:include href="common.xsl" />

  <!-- fill table, tbody, dl, ul, ol, span -->
  <xsl:template match="html:table[not(./html:tbody) and not(./html:tr)]|html:tbody[not(./html:tr)]|html:dl[not(html:dt|html:dd)]|html:ul[not(html:li)]|html:ol[not(html:li)]|html:span[not(./*) and not(@class)]">
    <xsl:variable name="query"><xsl:apply-templates select="text()"/></xsl:variable>
    <xsl:copy-of select="pg:query($query, name(.))"/>
  </xsl:template>

  <xsl:template match="html:pre[@class='postgres' or @class='mysql' or @class='oracle']">
    <xsl:variable name="query"><xsl:apply-templates select="text()"/></xsl:variable>
    <xsl:variable name="pre">pre-<xsl:value-of select="@class"/></xsl:variable>
    <pre class="{@class}"><xsl:value-of select="pg:query($query, $pre)"/></pre>
  </xsl:template>

  <xsl:template match="html:canvas">
    <xsl:variable name="query"><xsl:apply-templates select="text()"/></xsl:variable>
    <div class="graph" style="width:{@width}px">
      <!-- canvas node must be a child of a div node -->
      <div>
        <canvas id="{generate-id()}" width="{@width}" height="{@height}" />
        <script type="text/javascript">
graph('<xsl:value-of select="@type"/>', '<xsl:value-of select="generate-id()"/>',
<xsl:for-each select="pg:query($query, @type)">
 [<xsl:value-of select="values"/>],
 {<xsl:choose>
   <xsl:when test="boolean(vars)"><xsl:value-of select="vars"/></xsl:when>
   <xsl:otherwise>dummy:null</xsl:otherwise>
  </xsl:choose>
</xsl:for-each>
<xsl:for-each select="@*[name() != 'width' and name() != 'height' and name() != 'type']">
  ,<xsl:value-of select="name()"/>:<xsl:value-of select="."/>
</xsl:for-each>
});
        </script>
      </div>
      <xsl:for-each select="html:caption">
        <div class="caption"><xsl:value-of select="."/></div>
      </xsl:for-each>
    </div>
  </xsl:template>

</xsl:stylesheet>
