/* marshall.sql,v 1.1 2003/07/17 14:10:45 myui Exp
 *
 * ----------------------
 * Copyright (c) 2003 Makoto Yui <yuin@bb.din.or.jp>
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. The name of the author may not be used to endorse or promote
 *    products derived from this software without specific prior written
 *    permission.
 *
 * ALTERNATIVELY, this product may be distributed under the terms of
 * the GNU Public License (see COPYING.GPL), in which case the provisions
 * of the GPL are required INSTEAD OF the above restrictions.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */

/*
CREATE or REPLACE FUNCTION toxml(INTEGER) RETURNS VARCHAR
  AS '/usr/local/lib/xpsql/marshall.so'
  LANGUAGE 'C' STRICT;

CREATE or REPLACE FUNCTION toxml(INTEGER,VARCHAR) RETURNS VARCHAR
  AS '/usr/local/lib/xpsql/marshall.so'
  LANGUAGE 'C' STRICT;
*/

CREATE OR REPLACE FUNCTION toxml (INTEGER) RETURNS VARCHAR AS '
	DECLARE
		V_TMP_XN VARCHAR;
		V_RETXML VARCHAR;
		V_SQLSTMT VARCHAR;
		MVIEWS RECORD;
	BEGIN
		-- variables initialization
		V_TMP_XN := ''v_tmp_xn_'' || $1;
		V_RETXML := '''';

		SELECT INTO MVIEWS oid from pg_class where relname = V_TMP_XN::name;
		IF NOT FOUND THEN
			EXECUTE
				''create local temp table '' || V_TMP_XN || '' as '' ||
				''select trg.kind,trg.dewey,trg.tagid,trg.value '' ||
				''from xml_node trg,xml_node xn '' ||
				''where xn.id = '' || $1 || '' and _int_flagment(trg.dewey,xn.dewey)'';
		END IF;

		V_SQLSTMT := ''select xn.dewey as dewey, 1 as seq, ''''<'''' || xt.name as parsed_text from '' || V_TMP_XN || '' xn, xml_tag xt where xn.tagid = xt.tagid and xn.kind = ''''1'''''';
		V_SQLSTMT := V_SQLSTMT || '' union all select xn.dewey, xn.kind - 3, case when xn.kind = ''''5'''' then '''' '''' || xa.name || ''''="'''' || xn.value || ''''"'''' else '''' '''' || ns.name || ''''="'''' || xn.value || ''''"'''' end from '' || V_TMP_XN || '' xn left join xml_attribute xa using(tagid) left join xml_namespace ns using(tagid) where xn.kind = ''''5'''' or xn.kind = ''''6'''''';
		V_SQLSTMT := V_SQLSTMT || '' union all select xn.dewey + 0, 4 as seq, ''''>''''from '' || V_TMP_XN || '' xn where xn.kind = ''''1'''''';
		V_SQLSTMT := V_SQLSTMT || '' union all select xn.dewey, 5, case when xn.kind = ''''2'''' then xn.value when xn.kind = ''''3'''' then ''''<!-- '''' || xn.value || '''' -->'''' else ''''<?'''' || pi.name || xn.value || ''''?>'''' end from '' || V_TMP_XN || '' xn left join xml_pi pi using(tagid) where xn.kind = ''''2'''' or xn.kind = ''''3'''' or xn.kind = ''''4'''''';
		V_SQLSTMT := V_SQLSTMT || '' union all select xn.dewey + 2147483647, 6 as seq, ''''</'''' || xt.name || ''''>'''' from '' || V_TMP_XN || '' xn, xml_tag xt where xn.tagid = xt.tagid and xn.kind = ''''1'''' order by dewey, seq'';
		-- RAISE NOTICE ''%'',V_SQLSTMT;

		FOR MVIEWS IN EXECUTE V_SQLSTMT LOOP
			V_RETXML := V_RETXML || COALESCE(MVIEWS.parsed_text,'''');
		END LOOP;

		RETURN V_RETXML;
	END;
' LANGUAGE 'plpgsql' /* IMMUTABLE */ STRICT;

/*
create local temp table v_tmp_xn68149 as select trg.kind,trg.dewey,trg.tagid,trg.value from xml_node trg,xml_node xn where xn.id = 68149 and _int_flagment(trg.dewey,xn.dewey)
*/

/*
-- start element with left delimiter
SELECT
    xn.dewey as dewey,
    1 as seq,
    '<' || xt.name as parsed_text
FROM
    V_TMP_XN xn,
    xml_tag xt
WHERE
    xn.tagid = xt.tagid AND
    xn.kind = '1'
UNION ALL
-- attributes
SELECT
    xn.dewey,
    xn.kind - 3,
    case when xn.kind = '5' then ' ' || xa.name || '="' || xn.value || '"' else ' ' || ns.name || '="' || xn.value || '"' end
FROM
    V_TMP_XN xn left join xml_attribute xa using(tagid) left join xml_namespace ns using(tagid)
WHERE
    xn.kind = '5' OR
    xn.kind = '6'
UNION ALL
SELECT
    xn.dewey + 1,
    4 as seq,
    '>'
FROM
    V_TMP_XN xn where xn.kind = '1'
UNION ALL
SELECT
    xn.dewey,
    5,
    case when xn.kind = '2' then xn.value when xn.kind = '3' then '<!-- ' || xn.value || ' -->' else '<?' || pi.name || xn.value || '?>' end
FROM
    V_TMP_XN xn left join xml_pi pi using(tagid)
WHERE
    xn.kind = '2' OR
    xn.kind = '3' OR
    xn.kind = '4'
UNION ALL
SELECT
    xn.dewey + 2147483647,
    6 as seq,
    '</' || xt.name || '>'
FROM
    V_TMP_XN xn,
    xml_tag xt
WHERE
    xn.tagid = xt.tagid AND
    xn.kind = '1'
ORDER BY
    dewey,
    seq
*/