/* Module:          SQLGetCursorName.c
 *
 * Description:     Returns the cursor name associated with a specified statement. 
 *
 * Classes:         
 *
 * API functions:   SQLGetCursorName
 *
 * Comments:        See "notice.txt" for copyright and license information.
 *
 */

#include "driver.h"

SQLRETURN SQL_API SQLGetCursorName(
								   SQLHSTMT		hDrvStmt,
								   SQLCHAR		*szCursor,
								   SQLSMALLINT	nCursorMaxLength,
								   SQLSMALLINT	*pnCursorLength
								   )
{
	static char *func="SQLGetCursorName";
	StatementClass *stmt = (StatementClass *) hDrvStmt;
	int len = 0;
	SQLRETURN result;

	mylog("SQLGetCursorName: hDrvStmt=%u, szCursor=%u, nCursorMaxLength=%d, pnCursorLength=%u\n", hDrvStmt, szCursor, nCursorMaxLength, pnCursorLength);

	if ( ! stmt)
	{
		SC_log_error(func, "", NULL);
		return SQL_INVALID_HANDLE;
	}

	if ( stmt->cursor_name[0] == '\0')
	{
		stmt->errornumber = STMT_NO_CURSOR_NAME;
		stmt->errormsg = "No Cursor name available";
		SC_log_error(func, "", stmt);
		return SQL_ERROR;
	}

	result = SQL_SUCCESS;
	len = strlen(stmt->cursor_name);

	if (szCursor)
	{
		strncpy_null(szCursor, stmt->cursor_name, nCursorMaxLength);

		if (len >= nCursorMaxLength)
		{
			result = SQL_SUCCESS_WITH_INFO;
			stmt->errornumber = STMT_TRUNCATED;
			stmt->errormsg = "The buffer was too small for the result.";
		}
	}

	if (pnCursorLength)
	{
		*pnCursorLength = len;
	}

	return result;
}

