/* $PostgresPy: if/src/pstream.c,v 1.2 2004/07/27 09:53:21 flaw Exp $
 *
 * † Instrument:
 *     Copyright 2004, rhid development. All Rights Reserved.
 *     
 *     Usage of the works is permitted provided that this
 *     instrument is retained with the works, so that any entity
 *     that uses the works is notified of this instrument.
 *     
 *     DISCLAIMER: THE WORKS ARE WITHOUT WARRANTY.
 *     
 *     [2004, Fair License; rhid.com/fair]
 *     
 *//*
 * Pseudo streams, a file like interface to a function that "writes"
 */
#include <stdio.h>
#include <pputils.h>
#include <Python.h>
#include <structmember.h>
#include <py.h>
#include "pstream.h"

PyObj
ps_write(struct _pstream *self, PyObj strob)
{
	char *str;
	int strlen;

	if (!PyString_Check(strob))
	{
		PyErr_Format(PyExc_TypeError,
			"requires a string object, %s found",
			strob->ob_type->tp_name);
		return(NULL);
	}
	str = PyString_AS_STRING(strob);
	strlen = PyString_GET_SIZE(strob);

	if (self->ob_writer(str, strlen) == EOF)
	{
		PyErr_SetNone(PyExc_EOFError);
		return(NULL);
	}

	RETURN_NONE;
}

static PyMethodDef PyPStream_Methods[] = {
	{"write", (PyCFunction)ps_write, METH_O, "raw write"},
	
	{NULL}
};

static char PyPStream_Doc[] = "Pseudo stream object";
PyTypeObject PyPStream_Type = {
	PyObject_HEAD_INIT(NULL)
	0,										/* ob_size */
	"Pseudo Stream",					/* tp_name */
	sizeof(struct _pstream),		/* tp_basicsize */
	0,										/* tp_itemsize */
	(destructor)NULL,					/* tp_dealloc */
	NULL,									/* tp_print */
	(getattrfunc)NULL,				/* tp_getattr */
	(setattrfunc)NULL,				/* tp_setattr */
	(cmpfunc)NULL,						/* tp_compare */
	(reprfunc)NULL,					/* tp_repr */
	NULL,									/* tp_as_number */
	NULL,									/* tp_as_sequence */
	NULL,									/* tp_as_mapping */
	(hashfunc)NULL,					/* tp_hash */
	(ternaryfunc)NULL,				/* tp_call */
	(reprfunc)NULL,					/* tp_str */
	NULL,									/* tp_getattro */
	NULL,									/* tp_setattro */
	NULL,									/* tp_as_buffer */
	Py_TPFLAGS_DEFAULT,			   /* tp_flags */
	(char*)PyPStream_Doc,			/* tp_doc */
	(traverseproc)NULL,				/* tp_traverse */
	(inquiry)NULL,						/* tp_clear */
	(richcmpfunc)NULL,				/* tp_richcompare */
	(long)0,								/* tp_weaklistoffset */
	(getiterfunc)NULL,				/* tp_iter */
	(iternextfunc)NULL,				/* tp_iternext */
	PyPStream_Methods,				/* tp_methods */
	NULL,									/* tp_members */
	NULL,									/* tp_getset */
	NULL,									/* tp_base */
	NULL,									/* tp_dict */
	NULL,									/* tp_descr_get */
	NULL,									/* tp_descr_set */
	NULL,									/* tp_dictoffset */
	NULL,									/* tp_init */
	NULL,									/* tp_alloc */
	PyType_GenericNew,				/* tp_new */
};

PyObj
PyPStream_New(ps_writer writer)
{
	struct _pstream *rob;
	rob = (struct _pstream *)PyPStream_Type.tp_alloc(&PyPStream_Type, 0);
	rob->ob_writer = writer;
	return((PyObj)rob);
}
