.\\" auto-generated by docbook2man-spec $Revision: 1.25 $
.TH "SET" "" "29 March 2001" "SQL - Language Statements" "SQL Commands"
.SH NAME
SET \- Set run-time parameters
.SH SYNOPSIS
.sp
.nf
SET \fIvariable\fR { TO | = } { \fIvalue\fR | '\fIvalue\fR' | DEFAULT }
SET TIME ZONE { '\fItimezone\fR' | LOCAL | DEFAULT }
  
.sp
.fi
.SS "INPUTS"
.PP
.TP
\fB\fIvariable\fB\fR
A settable run-time parameter.
.TP
\fB\fIvalue\fB\fR
New value of parameter. \fBDEFAULT\fR can be
used to specify resetting the parameter to its default
value. Lists of strings are allowed, but more complex
constructs may need to be single or double quoted.
.PP
.SH "DESCRIPTION"
.PP
The \fBSET\fR command changes run-time configuration
parameters. The following parameters can be altered:
.TP
\fBCLIENT_ENCODING\fR
.TP
\fBNAMES\fR
Sets the multibyte client encoding. The specified encoding
must be supported by the backend.

This option is only available if
Postgres is build with multibyte
support.
.TP
\fBDATESTYLE\fR
Choose the date/time representation style. Two separate
settings are made: the default date/time output and the
interpretation of ambiguous input.

The following are date/time output styles:
.RS
.TP
\fBISO\fR
Use ISO 8601-style dates and times (YYYY-MM-DD
HH:MM:SS). This is the default.
.TP
\fBSQL\fR
Use Oracle/Ingres-style dates and times. Note that this
style has nothing to do with SQL (which mandates ISO 8601
style), the naming of this option is a historical accident.
.TP
\fBPostgres\fR
Use traditional Postgres format.
.TP
\fBGerman\fR
Use dd.mm.yyyy for numeric date representations.
.RE
.PP

The following two options determine both a substyle of the
``SQL'' and ``Postgres'' output formats
and the preferred interpretation of ambiguous date input.
.RS
.TP
\fBEuropean\fR
Use dd/mm/yyyy for numeric date representations.
.TP
\fBNonEuropean\fR
.TP
\fBUS\fR
Use mm/dd/yyyy for numeric date representations.
.RE
.PP

A value for \fBSET DATESTYLE\fR can be one from
the first list (output styles), or one from the second list
(substyles), or one from each separated by a comma.

Date format initialization may be done by:

Setting the \fBPGDATESTYLE\fR environment variable.
If PGDATESTYLE is set in the frontend environment of a client
based on libpq, libpq will automatically set DATESTYLE to the
value of PGDATESTYLE during connection start-up.

Running postmaster using the option \fB-o -e\fR to
set dates to the European convention.


The \fBDateStyle\fR option is really only intended
for porting applications. To format your date/time values to
choice, use the \fBto_char\fR family of
functions.
.TP
\fBSEED\fR
Sets the internal seed for the random number generator.
.RS
.TP
\fB\fIvalue\fB\fR
The value for the seed to be used by the
\fBrandom\fR function. Allowed
values are floating point numbers between 0 and 1, which
are then multiplied by 2^31-1. This product will
silently overflow if a number outside the range is used.

The seed can also be set by invoking the
\fBsetseed\fR SQL function:
.sp
.nf
SELECT setseed(\fIvalue\fR);
	    
.sp
.fi
.RE
.PP
.TP
\fBSERVER_ENCODING\fR
Sets the multibyte server encoding.

This option is only available if
Postgres was built with multibyte
support.
.TP
\fBTIME ZONE\fR
.TP
\fBTIMEZONE\fR
The possible values for time zone depends on your operating
system. For example, on Linux
\fI/usr/share/zoneinfo\fR contains the database
of time zones.

Here are some valid values for time zone:
.RS
.TP
\fBPST8PDT\fR
Set the time zone for California.
.TP
\fBPortugal\fR
Set time zone for Portugal.
.TP
\fB\&'Europe/Rome'\fR
Set time zone for Italy.
.TP
\fBLOCAL\fR
.TP
\fBDEFAULT\fR
Set the time zone to your local time zone (the one that
your operating system defaults to).
.RE
.PP

If an invalid time zone is specified, the time zone
becomes GMT (on most systems anyway).

If the PGTZ environment variable is set in the frontend
environment of a client based on libpq, libpq will automatically
set TIMEZONE to the value of PGTZ during connection start-up.
.PP
.PP
An extended list of other run-time parameters can be found in the
\fIAdministrator's Guide\fR.
.PP
Use SHOW [\fBshow\fR(l)] to show the
current setting of a parameters.
.SH "DIAGNOSTICS"
.PP
.TP
\fBSET VARIABLE\fR
Message returned if successful.
.TP
\fBERROR: not a valid option name: \fIname\fB\fR
The parameter you tried to set does not exist.
.TP
\fBERROR: permission denied\fR
You must be a superuser to have access to certain settings.
.TP
\fBERROR: \fIname\fB can only be set at start-up\fR
Some parameters are fixed once the server is started.
.PP
.SH "EXAMPLES"
.PP
Set the style of date to traditional Postgres with European conventions:
.sp
.nf
SET DATESTYLE TO Postgres,European;
.sp
.fi
Set the time zone for Berkeley, California, using double quotes to
preserve the uppercase attributes of the time zone specifier (note
that the date/time format is ISO here):
.sp
.nf
 
SET TIME ZONE "PST8PDT";
SELECT CURRENT_TIMESTAMP AS today;
   
         today
------------------------
 1998-03-31 07:41:21-08
.sp
.fi
Set the time zone for Italy (note the required single or double quotes to handle 
the special characters):
.sp
.nf
 
SET TIME ZONE 'Europe/Rome';
SELECT CURRENT_TIMESTAMP AS today;
   
         today
------------------------
 1998-03-31 17:41:31+02
.sp
.fi
.SH "COMPATIBILITY"
.SS "SQL92"
.PP
The second syntax shown above (SET TIME ZONE)
attempts to mimic SQL92. However, SQL allows
only numeric time zone offsets. All other parameter settings as
well as the first syntax shown above are a
Postgres extension.
