namespace eval ::files {
	namespace export *

	exception FileException Exception
	
	proc Grep {pPattern {pFileList ""}} {
		set lResult ""
		
		if {([llength $pFileList] == 0)} {
			set lLineNumber 0
			while {([gets stdin lLine] >= 0)} {
				incr lLineNumber
				if {([regexp $pPattern $lLine] != 0)} {
					lappend lResult "$lLineNumber:$lLine"
				}
			}
		} else {
			foreach lFileName $pFileList {
				set lFile [open $lFileName r]
				set lLineNumber 0
				while {([gets $lFile lLine] >= 0)} {
					incr lLineNumber
					if {[regexp $pPattern $lLine]} {
						lappend lResult "$lFileName:$lLineNumber:$lLine"
					}
				}
				close $lFile
			}
		}
		return $lResult
	}

	proc Find {{pDirectory "."} {pFilterCommand ""}} {
		set lOldDirectory [pwd]
		if {([catch {cd $pDirectory}] !=0)} {
			return ""
		}
		
		set lCurrentDirectory [pwd]
		set lFileList [lsort -dictionary [glob -nocomplain * .*]]
		set lNewFileList ""
		if {([string range $pFilterCommand 0 0] == "-") ||
		([string range $pFilterCommand 0 0] == "!")} {
			set lFilterCommand [string range $pFilterCommand 1 end]
			set lCondition 0
		} else {
			set lFilterCommand $pFilterCommand
			set lCondition 1
		}

		set lFilterCommandLength [string length $lFilterCommand]
		foreach lSpecialFileName [list "." ".."] {
			set lIndex [lsearch -exact $lFileList $lSpecialFileName]
			set lFileList [lreplace $lFileList $lIndex $lIndex]
		}
		foreach lFileName $lFileList {
			if {([file isdirectory $lFileName])} {
				set lNewFileList \
					[concat $lNewFileList [FindFile $lFileName $lFilterCommand]]
			} elseif {($lCondition == 0)} {
				if {($lFilterCommandLength == 0) || \
					([uplevel $lFilterCommand [list $lFileName]] == 0)} {
					lappend lNewFileList [file join $lCurrentDirectory $lFileName]
				}
			} else {
				if {($lFilterCommandLength == 0) || \
					([uplevel $lFilterCommand [list $lFileName]] != 0)} {
					lappend lNewFileList [file join $lCurrentDirectory $lFileName]
				}
			}
		}
		cd $lOldDirectory
		return $lNewFileList
	}

	proc Cat {pFilename} {
	    set lFile [open $pFilename r]
	    set lData [read $lFile [file size $pFilename]]
	    close $lFile
	    return $lData
	}

	proc ImportDelimitedFile {pFileName {pDelimiter "\t"} {pHasHeader "N"} {pHasTrailer "N"}} {
		set lFile [open $pFileName r]
		
		if {($pHasHeader == "Y") || ($pHasHeader == 1)} {
			gets $lFile lLine
			lappend lData $lLine
		}
		
		set lData ""
		while {([gets $lFile lLine] >= 0)} {
			set lList [split $lLine $pDelimiter]
			lappend lData $lList
		}
		close $lFile
		
		if {($pHasTrailer == "Y") || ($pHasTrailer == 1)} {
			set lEnd [expr [llength $lData] - 1]
			set lLine [lindex $lData $lEnd]
			set lNewLine [join $lLine $pDelimiter]
			set lData [lreplace $lData $lEnd $lEnd $lNewLine]
		}	
			
		return $lData
	}

	proc ImportINIFile {pFileName} {
		set lFile [open $pFileName r]
		set lData ""
		set lResult(COUNT) 0
		while {([gets $lFile lLine] >= 0)} {
			if {([regexp -nocase "^\\\[(\[a-z]\[a-z0-9_ :.]*)]" \
			$lLine ignore lBlockName])} {
				if {(![info exists lResult($lBlockName,COUNT)])} {
					lappend lResult(BLOCKS) $lBlockName
					incr lResult(COUNT)
					set lResult($lBlockName,COUNT) 0
					set lResult($lBlockName,PARAMETERS) ""
				}
			} elseif {([regexp -nocase \
			"^(\[a-z_]\[a-z0-9_\,\-.]*)\[ \t]*=\[ \t]*\"*(\[^\"]*)" \
			$lLine ignore lParameterName lParameterValue])} {			
				if {([info exists lBlockName])} {
					if {($lBlockName != "")} {
						if {(![info exists \
						lResult($lBlockName,$lParameterName)])} {
							lappend lResult($lBlockName,PARAMETERS) \
								$lParameterName
							set lResult($lBlockName,$lParameterName) \
								$lParameterValue
							incr lResult($lBlockName,COUNT)
						}
					}
				}
			}
		}
		
		return [array get lResult]
	}

	proc ImportMailRC {} {
		set mailrc_file [open "~/.mailrc" r] 
	
		while {(![eof $mailrc_file])} {
			gets $mailrc_file buffer
			if {([info exists alias_name])} {unset alias_name}
			if {([regexp "alias (.*) (.*)\\\\" $buffer ignore \
			alias_name email_names])} {
				set mail_alias_array($alias_name) $email_names
				set p_result FOUND
				while {(![eof $mailrc_file])} {
					gets $mailrc_file buffer
					if {([regexp "(.*)\\\\" $buffer ignore email_names])} {
						set mail_alias_array($alias_name) \
							"$mail_alias_array($alias_name)$email_names"
					} else {
						set mail_alias_array($alias_name) \
							"$mail_alias_array($alias_name)$buffer"
						break
					}
				}
			}
			if {([info exists alias_name])} {
				set email_temp_list ""
				for {set x 0} \
				{$x < [llength $mail_alias_array($alias_name)]} {incr x 1} {
					if ([info exists \
					mail_alias_array([lindex \
					$mail_alias_array($alias_name) $x])]) {
						set email_temp_list [string trim \
							"$email_temp_list $mail_alias_array([lindex $mail_alias_array($alias_name) $x])"]
					} else {
						set email_temp_list [string trim \
							"$email_temp_list [lindex $mail_alias_array($alias_name) $x]"]
					}
				}
			
				set mail_alias_array($alias_name) $email_temp_list
			
				set email_temp_list ""
				for {set x 0} \
				{$x < [llength $mail_alias_array($alias_name)]} {incr x 1} {
					if {([lsearch $email_temp_list \
					[lindex $mail_alias_array($alias_name) $x]] == -1)} {
						lappend email_temp_list \
							[lindex $mail_alias_array($alias_name) $x]
					}
				}
				set mail_alias_array($alias_name) $email_temp_list
			}
		}
		return [array get mail_alias_array]
	}
}
