/*
 * Decompiled with CFR 0.152.
 */
package com.parctechnologies.eclipse.visualisation;

import com.parctechnologies.eclipse.Atom;
import com.parctechnologies.eclipse.visualisation.BatchGoal;
import com.parctechnologies.eclipse.visualisation.BooleanGroupPropertyModel;
import com.parctechnologies.eclipse.visualisation.BooleanPropertyModel;
import com.parctechnologies.eclipse.visualisation.ContractEvent;
import com.parctechnologies.eclipse.visualisation.CreateEvent;
import com.parctechnologies.eclipse.visualisation.DestroyEvent;
import com.parctechnologies.eclipse.visualisation.ExpandEvent;
import com.parctechnologies.eclipse.visualisation.InterestSpec;
import com.parctechnologies.eclipse.visualisation.SymRef;
import com.parctechnologies.eclipse.visualisation.Viewable;
import com.parctechnologies.eclipse.visualisation.Viewer;
import com.parctechnologies.eclipse.visualisation.ViewerManager;
import com.parctechnologies.eclipse.visualisation.ViewerSetBooleanPropertyCommand;
import com.parctechnologies.eclipse.visualisation.ViewerSetPropagationStepsCommand;
import com.parctechnologies.eclipse.visualisation.VisClientStateModel;
import com.parctechnologies.eclipse.visualisation.VisEvent;
import java.awt.Component;
import java.awt.Rectangle;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.Action;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButtonMenuItem;

public abstract class ViewerImpl
implements Viewer {
    private InterestSpec interestSpec;
    private Viewable viewable;
    private VisEvent currentEvent;
    private VisClientStateModel stateModel;
    private ViewerManager viewerManager;
    private static final Atom fineAtom = new Atom("fine");
    private static final Atom timedAtom = new Atom("timed");
    private static final Atom coarseAtom = new Atom("coarse");
    private VPSRadioButton fineMenuButton;
    private VPSRadioButton timedMenuButton;
    private VPSRadioButton coarseMenuButton;
    private PropertyChangeSupport propertyChangeSupport = new PropertyChangeSupport(this);
    private JMenuBar jMenuBar = new JMenuBar();
    private Map menuTitleToMenu = new HashMap();
    private Map menuTitleToPopupMenu = new HashMap();
    private String description = "Viewer";
    private SymRef symRef;
    private boolean holdAtLastBacktrack = true;
    private boolean holdAtExpansions = true;
    private boolean holdAtContractions = true;

    public ViewerImpl(VisClientStateModel visClientStateModel, Viewable viewable) {
        this.setViewable(viewable);
        this.setInterestSpec(viewable.createInterestSpec());
        this.setStateModel(visClientStateModel);
        this.initialiseMenu();
        this.symRef = new SymRef(this, viewable.getSymRef(), this.getClass().getName());
    }

    @Override
    public void setViewerManager(ViewerManager viewerManager) {
        this.viewerManager = viewerManager;
    }

    @Override
    public void close() {
        PropertyChangeSupport propertyChangeSupport = this.stateModel.getPropertyChangeSupport();
        propertyChangeSupport.removePropertyChangeListener("canPerformRPC", this.fineMenuButton);
        propertyChangeSupport.removePropertyChangeListener("canPerformRPC", this.timedMenuButton);
        propertyChangeSupport.removePropertyChangeListener("canPerformRPC", this.coarseMenuButton);
        this.viewerManager.closeViewer(this);
    }

    private void initialiseMenu() {
        JCheckBoxMenuItem jCheckBoxMenuItem = new JCheckBoxMenuItem("Hold at destruction");
        jCheckBoxMenuItem.setModel(new BooleanPropertyModel("holdAtLastBacktrack", this, this.getPropertyChangeSupport()));
        JCheckBoxMenuItem jCheckBoxMenuItem2 = new JCheckBoxMenuItem("Hold at expansions");
        jCheckBoxMenuItem2.setModel(new BooleanPropertyModel("holdAtExpansions", this, this.getPropertyChangeSupport()));
        JCheckBoxMenuItem jCheckBoxMenuItem3 = new JCheckBoxMenuItem("Hold at contractions");
        jCheckBoxMenuItem3.setModel(new BooleanPropertyModel("holdAtContractions", this, this.getPropertyChangeSupport()));
        this.addMenuItem("Options", jCheckBoxMenuItem2);
        this.addMenuItem("Options", jCheckBoxMenuItem3);
        this.addMenuItem("Options", jCheckBoxMenuItem);
        ButtonGroup buttonGroup = new ButtonGroup();
        this.fineMenuButton = new VPSRadioButton(this, fineAtom);
        buttonGroup.add(this.fineMenuButton);
        this.addMenuItem("Options", this.fineMenuButton);
        this.coarseMenuButton = new VPSRadioButton(this, coarseAtom);
        buttonGroup.add(this.coarseMenuButton);
        this.addMenuItem("Options", this.coarseMenuButton);
        this.timedMenuButton = new VPSRadioButton(this, timedAtom);
        buttonGroup.add(this.timedMenuButton);
        this.addMenuItem("Options", this.timedMenuButton);
    }

    public void setHoldAtLastBacktrack(boolean bl) {
        new ViewerSetBooleanPropertyCommand(this, "holdAtLastBacktrack", bl).issue();
    }

    public void setHoldAtLastBacktrackPrivate(boolean bl) {
        boolean bl2 = this.holdAtLastBacktrack;
        this.holdAtLastBacktrack = bl;
        this.getPropertyChangeSupport().firePropertyChange("holdAtLastBacktrack", bl2, bl);
    }

    public boolean getHoldAtLastBacktrack() {
        return this.holdAtLastBacktrack;
    }

    public void setHoldAtExpansions(boolean bl) {
        new ViewerSetBooleanPropertyCommand(this, "holdAtExpansions", bl).issue();
    }

    public void setHoldAtExpansionsPrivate(boolean bl) {
        boolean bl2 = this.holdAtExpansions;
        this.holdAtExpansions = bl;
        this.getPropertyChangeSupport().firePropertyChange("holdAtExpansions", bl2, bl);
    }

    public boolean getHoldAtExpansions() {
        return this.holdAtExpansions;
    }

    public void setHoldAtContractions(boolean bl) {
        new ViewerSetBooleanPropertyCommand(this, "holdAtContractions", bl).issue();
    }

    public void setHoldAtContractionsPrivate(boolean bl) {
        boolean bl2 = this.holdAtContractions;
        this.holdAtContractions = bl;
        this.getPropertyChangeSupport().firePropertyChange("holdAtContractions", bl2, bl);
    }

    public boolean getHoldAtContractions() {
        return this.holdAtContractions;
    }

    public void setViewPropagationSteps(Object object) {
        new ViewerSetPropagationStepsCommand((Viewer)this, (Atom)object).issue();
    }

    public void setViewPropagationStepsPrivate(Object object) {
        Object object2 = this.getViewPropagationSteps();
        if (!object2.equals(object)) {
            this.getInterestSpec().setViewGranularity((Atom)object);
            this.propertyChangeSupport.firePropertyChange("viewPropagationSteps", object2, object);
        }
    }

    public Object getViewPropagationSteps() {
        return this.getInterestSpec().getViewGranularity();
    }

    public PropertyChangeSupport getPropertyChangeSupport() {
        return this.propertyChangeSupport;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public void setDescription(String string) {
        this.description = string;
    }

    protected int getMenuMnemonic(String string) {
        if ("Options".equals(string)) {
            return 79;
        }
        return -1;
    }

    private void addMenuItem(Map map, JMenuBar jMenuBar, String string, Object object) {
        JMenu jMenu = (JMenu)map.get(string);
        if (jMenu == null) {
            jMenu = new JMenu(string);
            int n = this.getMenuMnemonic(string);
            if (n != -1) {
                jMenu.setMnemonic(n);
            }
            if (jMenuBar != null) {
                jMenuBar.add(jMenu);
            }
            map.put(string, jMenu);
        } else if (object == null) {
            jMenu.addSeparator();
            return;
        }
        if (object instanceof Action) {
            jMenu.add((Action)object);
            return;
        }
        if (object instanceof JMenuItem) {
            jMenu.add((JMenuItem)object);
            return;
        }
    }

    protected void addMenuItem(String string, Object object) {
        this.addMenuItem(this.menuTitleToMenu, this.jMenuBar, string, object);
    }

    protected void addPopupMenuItem(String string, Object object) {
        this.addMenuItem(this.menuTitleToPopupMenu, null, string, object);
    }

    protected void addMenuAndPopupMenuItem(String string, Object object) {
        this.addMenuItem(this.menuTitleToMenu, this.jMenuBar, string, object);
        this.addMenuItem(this.menuTitleToPopupMenu, null, string, object);
    }

    public JMenu getPopupMenu(String string) {
        return (JMenu)this.menuTitleToPopupMenu.get(string);
    }

    @Override
    public JMenuBar getJMenuBar() {
        return this.jMenuBar;
    }

    @Override
    public InterestSpec getInterestSpec() {
        return this.interestSpec;
    }

    @Override
    public void setInterestSpec(InterestSpec interestSpec) {
        this.interestSpec = interestSpec;
    }

    @Override
    public void setStateModel(VisClientStateModel visClientStateModel) {
        this.stateModel = visClientStateModel;
    }

    protected VisClientStateModel getStateModel() {
        return this.stateModel;
    }

    @Override
    public Viewable getViewable() {
        return this.viewable;
    }

    protected void setViewable(Viewable viewable) {
        this.viewable = viewable;
    }

    @Override
    public abstract Component getComponent();

    protected VisEvent getCurrentEvent() {
        return this.currentEvent;
    }

    @Override
    public void prepareForEvent(VisEvent visEvent) {
        if (visEvent instanceof DestroyEvent) {
            this.getPropertyChangeSupport().firePropertyChange("destroyEventIssued", false, true);
        }
    }

    @Override
    public BatchGoal collectPreEventGoals(VisEvent visEvent) {
        return new BatchGoal();
    }

    @Override
    public void startEvent(VisEvent visEvent, List list) {
        this.currentEvent = visEvent;
    }

    @Override
    public boolean shouldHold() {
        if (this.currentEvent instanceof CreateEvent) {
            return true;
        }
        if (this.currentEvent instanceof DestroyEvent && this.holdAtLastBacktrack) {
            return true;
        }
        if (this.currentEvent instanceof ContractEvent && this.holdAtContractions) {
            return true;
        }
        return this.currentEvent instanceof ExpandEvent && this.holdAtExpansions;
    }

    @Override
    public void stopEvent() {
        this.currentEvent = null;
    }

    @Override
    public void gainFocus() {
    }

    @Override
    public void loseFocus() {
    }

    @Override
    public Rectangle getBounds() {
        return this.getComponent().getBounds();
    }

    @Override
    public void zoomInByRatio(float f) {
    }

    @Override
    public void zoomToLevel(float f) {
    }

    @Override
    public void setBounds(Rectangle rectangle) {
        this.getComponent().setBounds(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
    }

    public JPopupMenu getPopupMenu() {
        return new JPopupMenu();
    }

    @Override
    public void setSymRef(SymRef symRef) {
        this.symRef = symRef;
    }

    @Override
    public SymRef getSymRef() {
        return this.symRef;
    }

    private class VPSRadioButton
    extends JRadioButtonMenuItem
    implements PropertyChangeListener {
        VPSRadioButton(Object object, Atom atom) {
            super("View propagation steps (" + atom.functor() + ")");
            this.setModel(new BooleanGroupPropertyModel("viewPropagationSteps", object, ViewerImpl.this.getPropertyChangeSupport(), atom));
            ViewerImpl.this.stateModel.getPropertyChangeSupport().addPropertyChangeListener("canPerformRPC", this);
            ViewerImpl.this.getPropertyChangeSupport().addPropertyChangeListener("destroyEventIssued", this);
        }

        @Override
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if (propertyChangeEvent.getPropertyName() == "destroyEventIssued") {
                this.setEnabled(false);
            } else if (((Boolean)propertyChangeEvent.getNewValue()).booleanValue()) {
                this.setEnabled(true);
            } else {
                this.setEnabled(false);
            }
        }
    }
}

