/*
 * Decompiled with CFR 0.152.
 */
package att.grappa;

import att.grappa.Grappa;
import att.grappa.GrappaSupportPrintf;
import java.awt.geom.Point2D;

public class GrappaPoint
extends Point2D.Double {
    public GrappaPoint() {
    }

    public GrappaPoint(double x, double y) {
        this.x = x;
        this.y = y;
    }

    public GrappaPoint(String coordString) {
        try {
            int sepIdx = coordString.indexOf(44);
            if (sepIdx < 0 && (sepIdx = coordString.indexOf(32)) < 0 && (sepIdx = coordString.indexOf(9)) < 0) {
                this.x = Double.MIN_VALUE;
            }
            if (this.x != Double.MIN_VALUE) {
                this.x = Double.valueOf(coordString.substring(0, sepIdx));
                this.y = Double.valueOf(coordString.substring(sepIdx + 1));
            }
        }
        catch (NumberFormatException nfe) {
            throw new IllegalArgumentException("coordinate string (" + coordString + ") has a bad number format (" + nfe.getMessage() + ")");
        }
        if (this.x == Double.MIN_VALUE) {
            throw new IllegalArgumentException("coordinate string (" + coordString + ") does not contain 2 valid coordinates");
        }
        if (Grappa.negateStringYCoord) {
            this.y = -this.y;
        }
    }

    public String toAttributeString() {
        return this.toFormattedString("%p");
    }

    public String toFormattedString(String format) {
        return GrappaSupportPrintf.sprintf(new Object[]{format, this});
    }

    public String toString() {
        return this.x + "," + this.y;
    }
}

