/*
 * Decompiled with CFR 0.152.
 */
package ie.ucc.cccc.viz;

import ie.ucc.cccc.viz.Box;
import ie.ucc.cccc.viz.Colors;
import ie.ucc.cccc.viz.FullDomain;
import ie.ucc.cccc.viz.FullDomainMap;
import ie.ucc.cccc.viz.Pair;
import ie.ucc.cccc.viz.VisualContext;
import ie.ucc.cccc.viz.VisualState;
import ie.ucc.cccc.viz.VisualizerDrawer;
import ie.ucc.cccc.viz.VizFailed;
import ie.ucc.cccc.viz.VizFocus;
import java.io.PrintWriter;
import java.util.Iterator;
import java.util.Map;

public class VisualizerMatrix
extends VisualizerDrawer {
    public VisualizerMatrix(VisualContext visualContext) {
        super(visualContext);
    }

    @Override
    public void draw(PrintWriter printWriter, VisualState visualState) {
        FullDomainMap fullDomainMap = visualState.getEntries().asDomainMap();
        FullDomainMap fullDomainMap2 = visualState.getRemovedValues(fullDomainMap);
        printWriter.println("<!-- Matrix " + String.valueOf(this.context) + " -->");
        this.standardGrid(printWriter);
        for (Map.Entry entry : fullDomainMap.entrySet()) {
            this.drawMatrixEntry(printWriter, (Pair)entry.getKey(), (FullDomain)entry.getValue(), (FullDomain)fullDomainMap2.get(entry.getKey()));
        }
        this.drawFocus(printWriter, visualState.getFocus());
        this.drawFailed(printWriter, visualState.getFailed());
    }

    protected void drawMatrixEntry(PrintWriter printWriter, Pair pair, FullDomain fullDomain, FullDomain fullDomain2) {
        if (fullDomain.isFixed()) {
            Colors colors = fullDomain2 == null || fullDomain2.size() == 0 ? Colors.OLD_ASSIGN_COLOR : Colors.ASSIGN_COLOR;
            this.unitSquareSVG(printWriter, this.posX(pair), this.posY(pair), colors);
            this.textSVG(printWriter, this.posX(pair), this.posY(pair), fullDomain.getIntValue(), Colors.ASSIGNED_TEXT_COLOR);
        } else {
            this.unitSquareSVG(printWriter, this.posX(pair), this.posY(pair), Colors.UNASSIGNED_COLOR);
            if (this.context.getDisplay().equals("expanded")) {
                double d;
                double d2;
                int n;
                int n2 = this.context.getMax() - this.context.getMin() + 1;
                int n3 = (int)Math.ceil(Math.sqrt(n2));
                double d3 = 1.0 / (double)(n3 + 1);
                Iterator iterator = fullDomain.iterator();
                while (iterator.hasNext()) {
                    n = (Integer)iterator.next();
                    d2 = (double)pair.getY() + ((double)((n - this.context.getMin()) % n3) + 0.5) / (double)n3;
                    d = (double)pair.getX() + ((double)((n - this.context.getMin()) / n3) + 0.8) / (double)n3;
                    this.textSVG(printWriter, this.posX(d2), this.posY(d), d3, Integer.toString(n), Colors.UNASSIGNED_TEXT_COLOR);
                }
                if (fullDomain2 != null) {
                    iterator = fullDomain2.iterator();
                    while (iterator.hasNext()) {
                        n = (Integer)iterator.next();
                        d2 = (double)pair.getY() + ((double)((n - this.context.getMin()) % n3) + 0.5) / (double)n3;
                        d = (double)pair.getX() + ((double)((n - this.context.getMin()) / n3) + 0.8) / (double)n3;
                        this.textSVG(printWriter, this.posX(d2), this.posY(d), d3, Integer.toString(n), Colors.REMOVED_VALUE_TEXT_COLOR);
                    }
                }
            }
        }
    }

    protected void drawFocus(PrintWriter printWriter, VizFocus vizFocus) {
        if (this.isInFocus(vizFocus)) {
            printWriter.println("<!-- " + String.valueOf(vizFocus) + " -->");
            if (vizFocus.getType() == null) {
                Pair pair = vizFocus.getXYIndex();
                double d = this.posX(pair);
                double d2 = this.posY(pair);
                this.hollowRectSVG(printWriter, d, d2, 1.0, 1.0, Colors.FOCUS_COLOR);
            } else if (vizFocus.getType().equals("row")) {
                double d = this.leftX();
                double d3 = this.posY(vizFocus.getSingleIndex());
                this.hollowRectSVG(printWriter, d, d3, this.width(), 1.0, Colors.BLOCK_FOCUS_COLOR);
            } else if (vizFocus.getType().equals("col")) {
                double d = this.posX(vizFocus.getSingleIndex());
                double d4 = this.topY();
                this.hollowRectSVG(printWriter, d, d4, 1.0, this.height(), Colors.BLOCK_FOCUS_COLOR);
            } else if (vizFocus.getType().equals("block")) {
                Box box = vizFocus.getBoxIndex();
                double d = this.posX(box.getX());
                double d5 = this.posY(box.getY());
                this.hollowRectSVG(printWriter, d, d5, box.getWidth(), box.getHeight(), Colors.BLOCK_FOCUS_COLOR);
            } else {
                System.out.println("Unknown focus type: " + String.valueOf(vizFocus));
            }
        }
    }

    protected void drawFailed(PrintWriter printWriter, VizFailed vizFailed) {
        if (this.isFailed(vizFailed)) {
            Pair pair = vizFailed.getXYIndex();
            double d = this.posX(pair);
            double d2 = this.posY(pair);
            printWriter.println("<!-- " + String.valueOf(vizFailed) + " -->");
            this.unitSquareSVG(printWriter, d, d2, Colors.FAILED_COLOR);
            this.hollowRectSVG(printWriter, d, d2, 1.0, 1.0, Colors.FAILED_COLOR);
            this.textSVG(printWriter, d, d2, vizFailed.getValue(), Colors.FAILED_TEXT_COLOR);
        }
    }

    @Override
    public void standardGrid(PrintWriter printWriter) {
        int n;
        this.gridSVG(printWriter, this.leftX(), this.topY(), this.width(), this.height());
        for (n = this.context.getIndexStart(); n < this.height() + this.context.getIndexStart(); ++n) {
            this.textSVG(printWriter, (double)this.labelX(), this.posY(n), n, Colors.LABEL_TEXT_COLOR);
        }
        for (n = this.context.getIndexStart(); n < this.width() + this.context.getIndexStart(); ++n) {
            this.textSVG(printWriter, this.posX(n), (double)this.labelY(), n, Colors.LABEL_TEXT_COLOR);
        }
    }

    @Override
    public double posX(double d) {
        return (double)(this.context.getX() + 1) + d - (double)this.context.getIndexStart();
    }

    @Override
    public double posY(double d) {
        return (double)(this.context.getY() + 1) + d - (double)this.context.getIndexStart();
    }

    public double posX(Pair pair) {
        return this.posX(pair.getY());
    }

    public double posY(Pair pair) {
        return this.posY(pair.getX());
    }
}

