/*
 * Decompiled with CFR 0.152.
 */
package att.grappa;

import att.grappa.Edge;
import att.grappa.Element;
import att.grappa.Grappa;
import att.grappa.GrappaPoint;
import att.grappa.Subgraph;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.NoSuchElementException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Node
extends Element {
    public static final String defaultNamePrefix = "N";
    private ArrayList<Edge> inEdges = null;
    private ArrayList<Edge> outEdges = null;
    private ArrayList<Edge> Ports = null;
    static String[] NodeAttributesOfInterest = new String[]{"distortion", "height", "orientation", "peripheries", "pos", "sides", "skew", "style", "width"};

    public Node(Subgraph subg, String name) {
        super(1, subg);
        this.setName(name);
        this.nodeAttrsOfInterest();
    }

    public Node(Subgraph subg) {
        this(subg, (String)null);
    }

    private void nodeAttrsOfInterest() {
        this.attrOfInterest(NodeAttributesOfInterest);
    }

    @Override
    public boolean isNode() {
        return true;
    }

    @Override
    public int getType() {
        return 1;
    }

    @Override
    void setName() {
        String oldName = this.name;
        do {
            this.name = defaultNamePrefix + this.getId() + "_" + System.currentTimeMillis();
        } while (this.getGraph().findNodeByName(this.name) != null);
        if (oldName != null) {
            this.getSubgraph().removeNode(oldName);
        }
        this.getSubgraph().addNode(this);
        this.canonName = null;
        this.resetEdgeNames();
    }

    public void setName(String newName) throws IllegalArgumentException {
        if (newName == null) {
            this.setName();
            return;
        }
        String oldName = this.name;
        if (oldName != null && oldName.equals(newName)) {
            return;
        }
        if (this.getGraph().findNodeByName(newName) != null) {
            throw new IllegalArgumentException("node name (" + newName + ") is not unique");
        }
        if (oldName != null) {
            this.getSubgraph().removeNode(oldName);
        }
        this.name = newName;
        this.getSubgraph().addNode(this);
        this.canonName = null;
        this.resetEdgeNames();
    }

    private void resetEdgeNames() {
        Edge edge;
        int i;
        if (this.inEdges != null) {
            for (i = 0; i < this.inEdges.size(); ++i) {
                edge = this.inEdges.get(i);
                edge.canonName = null;
            }
        }
        if (this.outEdges != null) {
            for (i = 0; i < this.outEdges.size(); ++i) {
                edge = this.outEdges.get(i);
                edge.canonName = null;
            }
        }
    }

    public synchronized void addEdge(Edge edge, boolean inEdge) {
        if (edge == null) {
            return;
        }
        if (inEdge) {
            if (this.inEdges == null) {
                this.inEdges = new ArrayList();
            }
            if (!this.inEdges.contains(edge)) {
                this.inEdges.add(edge);
            }
        } else {
            if (this.outEdges == null) {
                this.outEdges = new ArrayList();
            }
            this.outEdges.add(edge);
            if (!this.outEdges.contains(edge)) {
                this.outEdges.add(edge);
            }
        }
    }

    public Edge findOutEdgeByKey(Node head, String key) {
        if (head == null || key == null || this.outEdges == null) {
            return null;
        }
        Edge edge = null;
        for (int i = 0; i < this.outEdges.size(); ++i) {
            edge = this.outEdges.get(i);
            if (head != edge.getHead() || !key.equals(edge.getKey())) continue;
            return edge;
        }
        return null;
    }

    public Edge findInEdgeByKey(Node tail, String key) {
        if (tail == null || key == null || this.inEdges == null) {
            return null;
        }
        Edge edge = null;
        for (int i = 0; i < this.inEdges.size(); ++i) {
            edge = this.inEdges.get(i);
            if (tail != edge.getTail() || !key.equals(edge.getKey())) continue;
            return edge;
        }
        return null;
    }

    public GrappaPoint getCenterPoint() {
        GrappaPoint pt = (GrappaPoint)this.getAttributeValue("pos");
        if (pt == null) {
            pt = new GrappaPoint();
        } else if (!Grappa.centerPointNodes) {
            Double w = (Double)this.getAttributeValue("width");
            Double h = (Double)this.getAttributeValue("height");
            if (w != null && h != null) {
                pt = new GrappaPoint(pt.x - w / 2.0, pt.y - h / 2.0);
            }
        } else {
            pt = new GrappaPoint(pt.x, pt.y);
        }
        return pt;
    }

    public synchronized void removeEdge(Edge edge, boolean inEdge) {
        if (edge == null) {
            return;
        }
        if (inEdge) {
            if (this.inEdges == null) {
                return;
            }
            this.inEdges.remove(edge);
        } else {
            if (this.outEdges == null) {
                return;
            }
            this.outEdges.remove(edge);
        }
    }

    public void printNode(PrintWriter out) {
        this.printElement(out);
    }

    public static int attributeType(String attrname) {
        int convtype = -1;
        if (attrname != null) {
            int hashCode = attrname.hashCode();
            if (hashCode == DISTORTION_HASH && attrname.equals("distortion")) {
                convtype = 4;
            } else if (hashCode == ORIENTATION_HASH && attrname.equals("orientation")) {
                convtype = 4;
            } else if (hashCode == PERIPHERIES_HASH && attrname.equals("peripheries")) {
                convtype = 7;
            } else if (hashCode == POS_HASH && attrname.equals("pos")) {
                convtype = 9;
            } else if (hashCode == SHAPE_HASH && attrname.equals("shape")) {
                convtype = 10;
            } else if (hashCode == SIDES_HASH && attrname.equals("sides")) {
                convtype = 7;
            } else if (hashCode == SKEW_HASH && attrname.equals("skew")) {
                convtype = 4;
            } else {
                return Element.attributeType(attrname);
            }
        }
        return convtype;
    }

    public Iterator<Edge> edgeElements() {
        return new Iterator<Edge>(this.inEdges, this.outEdges);
    }

    public Edge[] edgeElementsAsArray() {
        ArrayList<Edge> elist = new ArrayList<Edge>();
        if (this.inEdges != null) {
            elist.addAll(this.inEdges);
        }
        if (this.outEdges != null) {
            elist.addAll(this.outEdges);
        }
        Edge[] edges = new Edge[elist.size()];
        edges = elist.toArray(edges);
        return edges;
    }

    public Iterator<Edge> inEdgeElements() {
        return new Iterator<Edge>(this.inEdges, null);
    }

    public Iterator<Edge> outEdgeElements() {
        return new Iterator<Edge>(null, this.outEdges);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class Iterator<Edge>
    implements java.util.Iterator<Edge> {
        int inCnt = 0;
        int outCnt = 0;
        ArrayList<Edge> inEdges = null;
        ArrayList<Edge> outEdges = null;

        Iterator(ArrayList<Edge> inEdges, ArrayList<Edge> outEdges) {
            this.inCnt = inEdges == null ? 0 : inEdges.size();
            this.outCnt = outEdges == null ? 0 : outEdges.size();
            this.inEdges = inEdges;
            this.outEdges = outEdges;
        }

        @Override
        public boolean hasNext() {
            int tmp;
            if (this.inCnt > 0 && this.inCnt > (tmp = this.inEdges.size())) {
                this.inCnt = tmp;
            }
            if (this.outCnt > 0 && this.outCnt > (tmp = this.outEdges.size())) {
                this.outCnt = tmp;
            }
            return this.inCnt + this.outCnt > 0;
        }

        @Override
        public Edge next() {
            Node node = Node.this;
            synchronized (node) {
                int tmp;
                if (this.inCnt > 0 && this.inCnt > (tmp = this.inEdges.size())) {
                    this.inCnt = tmp;
                }
                if (this.inCnt > 0) {
                    return this.inEdges.get(--this.inCnt);
                }
                if (this.outCnt > 0 && this.outCnt > (tmp = this.outEdges.size())) {
                    this.outCnt = tmp;
                }
                if (this.outCnt > 0) {
                    return this.outEdges.get(--this.outCnt);
                }
                throw new NoSuchElementException("Node$Enumerator");
            }
        }

        @Override
        public void remove() {
        }
    }
}

